VERSION 5.00
Begin VB.Form frmSysTray 
   BorderStyle     =   0  'None
   ClientHeight    =   1740
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   2760
   ClipControls    =   0   'False
   ControlBox      =   0   'False
   Icon            =   "SysTray.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1740
   ScaleWidth      =   2760
   ShowInTaskbar   =   0   'False
   Begin VB.Menu mnuPopup 
      Caption         =   ""
      Begin VB.Menu mnuSysTray 
         Caption         =   ""
         Index           =   0
      End
   End
End
Attribute VB_Name = "frmSysTray"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Declare Function Shell_NotifyIconA Lib "shell32.dll" (ByVal dwMessage As Long, lpData As NOTIFYICONDATAA) As Long
Private Declare Function Shell_NotifyIconW Lib "shell32.dll" (ByVal dwMessage As Long, lpData As NOTIFYICONDATAW) As Long
Private Declare Function GetVersion Lib "kernel32" () As Long
Private Declare Function SetForegroundWindow Lib "user32" (ByVal hwnd As Long) As Long

'NIM=Notify Icon Message
'NIF=Notify Icon Flag
Private Const NIF_MESSAGE = &H1
Private Const NIF_ICON = &H2
Private Const NIF_TIP = &H4
Private Const NIF_STATE = NIF_TIP * 2
Private Const NIF_INFO = &H10
Private Const NIM_ADD = &H0 '0
Private Const NIM_MODIFY = NIF_MESSAGE '1
Private Const NIM_DELETE = NIF_ICON '2
Private Const NIM_SETFOCUS = NIM_DELETE + 1 '3
Private Const NIM_SETVERSION = NIF_TIP '4
Private Const NOTIFYICON_VERSION = NIM_SETFOCUS '3

Private Type NOTIFYICONDATAA
   cbSize As Long             ' 4
   hwnd As Long               ' 8
   uID As Long                ' 12
   uFlags As Long             ' 16
   uCallbackMessage As Long   ' 20
   hIcon As Long              ' 24
   szTip As String * 128      ' 152
   dwState As Long            ' 156
   dwStateMask As Long        ' 160
   szInfo As String * 256     ' 416
   uTimeOutOrVersion As Long  ' 420
   szInfoTitle As String * 64 ' 484
   dwInfoFlags As Long        ' 488
   guidItem As Long           ' 492
End Type
Private Type NOTIFYICONDATAW
   cbSize As Long             ' 4
   hwnd As Long               ' 8
   uID As Long                ' 12
   uFlags As Long             ' 16
   uCallbackMessage As Long   ' 20
   hIcon As Long              ' 24
   szTip(0 To 255) As Byte    ' 280
   dwState As Long            ' 284
   dwStateMask As Long        ' 288
   szInfo(0 To 511) As Byte   ' 800
   uTimeOutOrVersion As Long  ' 804
   szInfoTitle(0 To 127) As Byte ' 932
   dwInfoFlags As Long        ' 936
   guidItem As Long           ' 940
End Type


Private nfIconDataA As NOTIFYICONDATAA
Private nfIconDataW As NOTIFYICONDATAW

Private Const NOTIFYICONDATAA_V1_SIZE_A = 88
Private Const NOTIFYICONDATAA_V1_SIZE_U = 152
Private Const NOTIFYICONDATAA_V2_SIZE_A = 488
Private Const NOTIFYICONDATAA_V2_SIZE_U = 936

Private Const WM_USER = &H400
Private Const NIN_SELECT = WM_USER
Private Const NINF_KEY = &H1
Private Const NIN_KEYSELECT = (NIN_SELECT Or NINF_KEY)

' Version detection:

Public Event SysTrayMouseDown(ByVal eButton As MouseButtonConstants)
Public Event SysTrayDoubleClick(ByVal eButton As MouseButtonConstants)
Public Event MenuClick(ByVal lIndex As Long, ByVal sKey As String)

Private m_bUseUnicode As Boolean, m_bSupportsNewVersion As Boolean, m_bAddedMenuItem, m_iDefaultIndex As Long

Public Sub Delete(): Shell_NotifyIconA NIM_DELETE, nfIconDataA: Shell_NotifyIconW NIM_DELETE, nfIconDataW: End Sub

Public Property Get ToolTip() As String
Dim sTip As String, iPos As Long
    sTip = nfIconDataA.szTip: iPos = InStr(sTip, Chr$(0))
    If (iPos <> 0) Then sTip = Left$(sTip, iPos - 1)
    ToolTip = sTip
End Property
Public Property Let ToolTip(ByVal sTip As String)
   If (m_bUseUnicode) Then
      stringToArray sTip, nfIconDataW.szTip, unicodeSize(IIf(m_bSupportsNewVersion, 128, 64))
      nfIconDataW.uFlags = NIF_TIP
      Shell_NotifyIconW NIM_MODIFY, nfIconDataW
   Else
      If (sTip & Chr$(0) <> nfIconDataA.szTip) Then
         nfIconDataA.szTip = sTip & Chr$(0)
         nfIconDataA.uFlags = NIF_TIP
         Shell_NotifyIconA NIM_MODIFY, nfIconDataA
      End If
   End If
End Property

Public Property Get IconHandle() As Long: IconHandle = nfIconDataA.hIcon: End Property

Public Property Let IconHandle(ByVal hIcon As Long)
   If (m_bUseUnicode) Then
      If (hIcon <> nfIconDataW.hIcon) Then
         nfIconDataW.hIcon = hIcon
         nfIconDataW.uFlags = NIF_ICON
         Shell_NotifyIconW NIM_MODIFY, nfIconDataW
      End If
   Else
      If (hIcon <> nfIconDataA.hIcon) Then
         nfIconDataA.hIcon = hIcon
         nfIconDataA.uFlags = NIF_ICON
         Shell_NotifyIconA NIM_MODIFY, nfIconDataA
      End If
   End If
End Property

Public Function AddExistingMenu(Name As Menu)
AddMenuItem Name.Caption, LCase(Name.Caption), False
End Function

Public Function AddMenuItem(ByVal sCaption As String, Optional ByVal sKey As String = vbNullString, Optional ByVal bDefault As Boolean = False) As Long
Dim iIndex As Long
    If Not m_bAddedMenuItem Then
        iIndex = 0
        m_bAddedMenuItem = True
    Else
        iIndex = mnuSysTray.UBound + 1
        Load mnuSysTray(iIndex)
    End If
    mnuSysTray(iIndex).Visible = True
    mnuSysTray(iIndex).Tag = sKey
    mnuSysTray(iIndex).Caption = sCaption
    If bDefault Then m_iDefaultIndex = iIndex
    AddMenuItem = iIndex
End Function

Private Function ValidIndex(ByVal lIndex As Long) As Boolean: ValidIndex = (lIndex >= mnuSysTray.LBound And lIndex <= mnuSysTray.UBound): End Function

Public Sub EnableMenuItem(ByVal lIndex As Long, ByVal bState As Boolean): If (ValidIndex(lIndex)) Then mnuSysTray(lIndex).Enabled = bState
End Sub

Public Function RemoveMenuItem(ByVal iIndex As Long) As Long
Dim i As Long
   If ValidIndex(iIndex) Then
      If (iIndex = 0) Then
         mnuSysTray(0).Caption = vbNullString
      Else
         ' remove the item:
         For i = iIndex + 1 To mnuSysTray.UBound
            mnuSysTray(iIndex - 1).Caption = mnuSysTray(iIndex).Caption
            mnuSysTray(iIndex - 1).Tag = mnuSysTray(iIndex).Tag
         Next i
         Unload mnuSysTray(mnuSysTray.UBound)
      End If
   End If
End Function

Public Property Get DefaultMenuIndex() As Long: DefaultMenuIndex = m_iDefaultIndex: End Property

Public Property Let DefaultMenuIndex(ByVal lIndex As Long)
   If (ValidIndex(lIndex)) Then m_iDefaultIndex = lIndex Else m_iDefaultIndex = 0
End Property

Public Function ShowMenu()
   SetForegroundWindow Me.hwnd
   If (m_iDefaultIndex > -1) Then PopupMenu mnuPopup, 0, , , mnuSysTray(m_iDefaultIndex) Else PopupMenu mnuPopup, 0
End Function

Private Sub Form_Load()
   ' Get version:
   Dim lMajor As Long, lMinor As Long, bIsNt As Long
   GetWindowsVersion lMajor, lMinor, , , bIsNt
   If (bIsNt) Then
      m_bUseUnicode = True
      If (lMajor >= 5) Then m_bSupportsNewVersion = True ' 2000 or XP
   ElseIf (lMajor = 4) And (lMinor = 90) Then
      m_bSupportsNewVersion = True ' Windows ME
   End If
   
   'Add the icon to the system tray...
   Dim lR As Long
   
   If (m_bUseUnicode) Then
      With nfIconDataW
         .hwnd = Me.hwnd
         .uID = Me.Icon
         .uFlags = NIF_ICON Or NIF_MESSAGE Or NIF_TIP
         .uCallbackMessage = WM_MOUSEMOVE
         .hIcon = Me.Icon.Handle
         stringToArray App.FileDescription, .szTip, unicodeSize(IIf(m_bSupportsNewVersion, 128, 64))
         If (m_bSupportsNewVersion) Then
            .uTimeOutOrVersion = NOTIFYICON_VERSION
         End If
         .cbSize = nfStructureSize
      End With
      
      lR = Shell_NotifyIconW(NIM_ADD, nfIconDataW)
      If (m_bSupportsNewVersion) Then Shell_NotifyIconW NIM_SETVERSION, nfIconDataW
   Else
      With nfIconDataA
         .hwnd = Me.hwnd
         .uID = Me.Icon
         .uFlags = NIF_ICON Or NIF_MESSAGE Or NIF_TIP
         .uCallbackMessage = WM_MOUSEMOVE
         .hIcon = Me.Icon.Handle
         .szTip = App.FileDescription & Chr$(0)
         If (m_bSupportsNewVersion) Then .uTimeOutOrVersion = NOTIFYICON_VERSION
         .cbSize = nfStructureSize
      End With
      lR = Shell_NotifyIconA(NIM_ADD, nfIconDataA)
      If (m_bSupportsNewVersion) Then lR = Shell_NotifyIconA(NIM_SETVERSION, nfIconDataA)
   End If
End Sub

Private Sub stringToArray( _
      ByVal sString As String, _
      bArray() As Byte, _
      ByVal lMaxSize As Long _
   )
Dim b() As Byte, i As Long, j As Long
   If Len(sString) > 0 Then
      b = sString
      For i = LBound(b) To UBound(b)
         bArray(i) = b(i)
         If (i = (lMaxSize - 2)) Then Exit For
      Next i
      For j = i To lMaxSize - 1
         bArray(j) = 0
      Next j
   End If
End Sub
Private Function unicodeSize(ByVal lSize As Long) As Long
   If (m_bUseUnicode) Then unicodeSize = lSize * 2 Else unicodeSize = lSize
End Function

Private Property Get nfStructureSize() As Long
   If (m_bSupportsNewVersion) Then
      If (m_bUseUnicode) Then nfStructureSize = NOTIFYICONDATAA_V2_SIZE_U Else nfStructureSize = NOTIFYICONDATAA_V2_SIZE_A
   Else
      If (m_bUseUnicode) Then nfStructureSize = NOTIFYICONDATAA_V1_SIZE_U Else nfStructureSize = NOTIFYICONDATAA_V1_SIZE_A
   End If
End Property

Private Sub Form_MouseMove(Button As Integer, Shift As Integer, X As Single, Y As Single)
Dim lX As Long: lX = ScaleX(X, Me.ScaleMode, vbPixels)
Select Case lX
Case WM_LBUTTONDBLCLK: RaiseEvent SysTrayDoubleClick(vbLeftButton)
Case WM_RBUTTONDOWN: RaiseEvent SysTrayMouseDown(vbRightButton)
End Select
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer): If (m_bUseUnicode) Then Shell_NotifyIconW NIM_DELETE, nfIconDataW Else Shell_NotifyIconA NIM_DELETE, nfIconDataA
End Sub

Private Sub mnuSysTray_Click(Index As Integer): RaiseEvent MenuClick(Index, mnuSysTray(Index).Tag): End Sub

Private Sub GetWindowsVersion( _
      Optional ByRef lMajor = 0, _
      Optional ByRef lMinor = 0, _
      Optional ByRef lRevision = 0, _
      Optional ByRef lBuildNumber = 0, _
      Optional ByRef bIsNt = False _
   )
Dim lR As Long
   lR = GetVersion()
   lBuildNumber = (lR And &H7F000000) \ &H1000000
   If (lR And &H80000000) Then lBuildNumber = lBuildNumber Or &H80
   lRevision = (lR And &HFF0000) \ &H10000
   lMinor = (lR And &HFF00&) \ &H100
   lMajor = (lR And &HFF)
   bIsNt = ((lR And &H80000000) = 0)
End Sub
